@extends('admin.base.base')
@section('titulo', 'Sócio ')
@section('content')
    <div class="content-wrapper" style="min-height: 513px;">
        <div class="container-full">
            <section class="content">
                <div class="row">
                    <div class="col-12">
                        <form action="{{ route('cliente.update', $User) }}" method="post" enctype="multipart/form-data">
                            @csrf
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-info-sign"></i> Foto do sócio</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="mb-3 col-sm-12">
                                                <label class="form-label" for="imageInput">
                                                    <img src="{{ !empty($User->foto) ? url("storage/{$User->foto}") : url('site/images/sem-foto.jpeg') }}" id="selectedImage" width="150" style="border-radius: 20px;">
                                                    <br>
                                                    Clique para anexar Foto, tamanho máximo 8Mb
                                                </label>
                                                <input name="image" type="file" class="form-control" style="display: none" id="imageInput" accept="image/*">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-map-marker"></i> Dados Pessoais</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Nome Completo</label>
                                                    <input name="name" value="{{ $User->name }} {{ $User->sobrenome }}" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">CPF</label>
                                                    <input name="cpf" id="cpf" value="{{ $User->cpf }}" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">RG</label>
                                                    <input name="rg" id="rg" value="{{ $User->rg }}" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">E-mail</label>
                                                    <input name="email" id="email" value="{{ $User->email }}" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Celular</label>
                                                    <input name="celular" id="celular" value="{{ $User->celular }}" type="text" class="form-control celular">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Sexo</label>
                                                    <select name="sexo" id="sexo" class="form-select" data-placeholder="Choose a Category" tabindex="1">
                                                        <option value="Selecione uma opção">Selecione uma opção</option>
                                                        <option value="Masculino" {{ $User->sexo == 'Masculino' ? 'selected' : '' }}>Masculino </option>
                                                        <option value="Feminino" {{ $User->sexo == 'Feminino' ? 'selected' : '' }}>Feminino </option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Pai</label>
                                                    <input name="pai" id="pai" value="{{ $User->pai }}" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Mãe</label>
                                                    <input name="mae" id="mae" value="{{ $User->mae }}" type="text" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-map-marker"></i> Dados Sócio</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Tamaho da Camisa</label>
                                                    <input name="tamanho_camisa" id="tamanho_camisa" value="{{ $User->tamanho_camisa }}" type="text" class="form-control">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Sócio do Bahia?</label>
                                                    <select name="socio_bahia" id="socio_bahia" class="form-select" data-placeholder="Choose a Category" tabindex="1">
                                                        <option value="Selecione uma opção">Selecione uma opção</option>
                                                        <option value="Sim" {{ $User->socio_bahia == 'Sim' ? 'selected' : '' }}>Sim </option>
                                                        <option value="Não" {{ $User->socio_bahia == 'Não' ? 'selected' : '' }}>Não </option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Distrito</label>
                                                    <select name="distrito" id="distrito" class="form-select" data-placeholder="Choose a Category" tabindex="1">
                                                        <option value="Selecione uma opção">Selecione um distrito</option>
                                                        <option value="{{ $User->distrito }}" selected>{{ $User->distrito }}</option>
                                                        @for ($i = 1; $i <= 33; $i++)
                                                            <option value="{{ $i }}º Distrito">
                                                                {{ $i }}º Distrito
                                                            </option>
                                                        @endfor
                                                        <option value="Distrito Feminino">
                                                            Distrito Feminino
                                                        </option>
                                                        <option value="Não Tenho">
                                                            Não Tenho
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Menor de idade?</label>
                                                    <select name="menor_idade" id="menor_idade" class="form-select" data-placeholder="Choose a Category" tabindex="1">
                                                        <option value="Selecione uma opção">Selecione uma opção</option>
                                                        <option value="Sim" {{ $User->menor_idade == 'Sim' ? 'selected' : '' }}>Sim </option>
                                                        <option value="Não" {{ $User->menor_idade == 'Não' ? 'selected' : '' }}>Não </option>
                                                    </select>
                                                </div>
                                            </div>
                                            @if ($User->menor_idade == 'Sim')
                                                <div class="col-lg-6 col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="form-label">Nome do responsável</label>
                                                        <input name="responsavel" value="{{ $User->responsavel }}" type="text" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="form-label">Parentesco</label>
                                                        <input name="parentesco" value="{{ $User->parentesco }}" type="text" class="form-control">
                                                    </div>
                                                </div>
                                                <div class="col-lg-6 col-md-6 col-12">
                                                    <div class="form-group">
                                                        <label class="form-label">Telefone do responsável</label>
                                                        <input name="responsavel_celular" value="{{ $User->responsavel_celular }}" type="text" class="form-control celular">
                                                    </div>
                                                </div>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-map-marker"></i> Endereço</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">CEP</label>
                                                    <input name="cep" id="cep" value="{{ $User->cep }}" type="tel" class="form-control cep" placeholder="CEP">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Endereço</label>
                                                    <input name="endereco" id="endereco" value="{{ $User->endereco }}" type="text" class="form-control" placeholder="Endereço">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Nº</label>
                                                    <input name="numero" id="numero" value="{{ $User->numero }}" type="text" class="form-control" placeholder="Nº">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Complemento</label>
                                                    <input name="complemento" id="complemento" value="{{ $User->complemento }}" type="text" class="form-control" placeholder="Complemento">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Bairro</label>
                                                    <input name="bairro" id="bairro" value="{{ $User->bairro }}" type="text" class="form-control" placeholder="Bairro">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-6 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Cidade</label>
                                                    <input name="cidade" id="cidade" value="{{ $User->cidade }}" type="text" class="form-control" placeholder="Cidade">
                                                </div>
                                            </div>
                                            <div class="col-lg-6 col-md-3 col-12">
                                                <div class="form-group">
                                                    <label class="form-label">Estado</label>
                                                    <select name="estado" id="estado" class="form-select" data-placeholder="Choose a Category" tabindex="1">
                                                        <option value="Selecione um estado">Selecione um estado</option>
                                                        @foreach ($Estados as $estado)
                                                            <option value="{{ $estado->uf }}" {{ $estado->uf == $User->estado ? 'selected' : '' }}>{{ $estado->uf }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-calendar"></i> Datas</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="col-lg-3 col-md-3 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Sócio desde</label>
                                                    <input name="created_at" value="{{ date('Y-m-d', strtotime($User->created_at)) }}" type="date" class="form-control date-time">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Próximo Vencimento</label>
                                                    <input name="vencimento" value="{{ !empty($User->Assinatura->vencimento) ? $User->Assinatura->vencimento : '' }}" type="date" class="form-control date-time">
                                                </div>
                                            </div>
                                            <div class="col-lg-3 col-md-3 col-6">
                                                <div class="form-group">
                                                    <label class="form-label">Data de Nascimento</label>
                                                    <input name="nascimento" value="{{ $User->nascimento }}" type="date" class="form-control date-time">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-ticket"></i> Pagamentos</h4>
                                        <hr class="my-15">
                                        <div class="row">
                                            <div class="col-md-12 text-center" style="margin: 50px 0;">
                                                <p class="text-center">Deseja gerar uma cobrança?</p>
                                                <button data-bs-toggle="modal" data-bs-target=".modal_assinatura" type="button" class="waves-effect waves-light btn btn-outline btn-rounded btn-info mb-5">Assinaturas</button>
                                                <button data-bs-toggle="modal" data-bs-target=".modal_gerar_cobranca" type="button" class="waves-effect waves-light btn btn-outline btn-rounded btn-info mb-5">Gerar Cobrança</button>
                                            </div>
                                            <div class="table-responsive-sm">
                                                <table class="table mb-0">
                                                    <thead>
                                                        <tr>
                                                            <th scope="col">ID</th>
                                                            <th scope="col">Ref</th>
                                                            <th scope="col">Vencimento</th>
                                                            <th scope="col">Data PG</th>
                                                            <th scope="col">Valor</th>
                                                            <th scope="col">Taxa</th>
                                                            <th scope="col">Status</th>
                                                            <th scope="col"></th>
                                                            <th scope="col"></th>
                                                        </tr>
                                                    </thead>
                                                    <tbody id="result_boletos">
                                                        {{-- @foreach ($User->Boletos as $Boleto)
                                                            <tr>
                                                                <td>{{ $Boleto->id }}</td>
                                                                <td>{{ $Boleto->ref }}</td>
                                                                <td>{{ date('d/m/Y', strtotime($Boleto->vencimento)) }}</td>
                                                                <td>{{ !empty($Boleto->data_pago) ? date('d/m/Y', strtotime($Boleto->data_pago)) : '--/--/----' }}</td>
                                                                <td>R$ {{ moeda($Boleto->valor) }}</td>
                                                                <td>R$ {{ moeda(porcentagem(env('TAXA_LOPAK'), $Boleto->valor)) }} </td>
                                                                <td>
                                                                    <span class="badge badge-{{ $cor_status_boleto[$Boleto->status] }}">{{ $status_boleto[$Boleto->status] }}</span>
                                                                </td>
                                                                <td>
                                                                    <a href="https://api.whatsapp.com/send?phone=55{{ setUri2($User->celular) }}&text=Olá {{ $User->name }}, segue sua cobrança no valor de R$ {{ moeda($Boleto->valor) }}, referente a {{ $Boleto->ref }}, acesse: {{ route('pay.farura',[$Boleto->pedido_id,$Boleto->id]) }}" target="_blank" rel="noopener noreferrer">
                                                                        <span class="badge badge-success"><img src="{{ url('adm/images/whatsapp-logo-big.png') }}" width="18"> Compartilhar</span>
                                                                    </a>
                                                                </td>
                                                                <td>
                                                                    <a href="javascript:void(0)" onclick="javascript:BoletoShow({{ $Boleto->id }})">
                                                                        <i class="glyphicon glyphicon-pencil"></i>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                        @endforeach --}}
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <h4 class="box-title text-info mb-0"><i class="glyphicon glyphicon-info-sign"></i> Relatos sobre o sócio</h4>
                                        <p>Registre tudo que achar necessário, se o sócio cometou alguma infração e merece um registro, assim como se ele precisa de uma observação para outro assunto.</p>
                                        <div class="row">
                                            <textarea id="editor1" name="editor1"></textarea>
                                            <textarea name="descricao" class="textarea" style="width: 100%; height: 200px; font-size: 14px; line-height: 18px; border: 1px solid #dddddd; padding: 10px;">{{ $User->descricao }}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-12 col-12">
                                <div class="box">
                                    <div class="box-body">
                                        <div class="row">
                                            <div class="col-md-12">
                                                <div class="form-group">
                                                    <label class="form-label">Nivel de Acesso</label>
                                                    <div class="radio-list">
                                                        <label class="p-0 radio-inline me-10">
                                                            <div class="radio radio-info">
                                                                <input id="statusv" type="radio" name="tipo" value="Visitante" {{ $User->cargo == 'Sócio' && $User->status == 'Inativo' ? 'checked' : '' }}>
                                                                <label for="statusv">Visitante</label>
                                                            </div>
                                                        </label>
                                                        <label class="p-0 radio-inline me-10">
                                                            <div class="radio radio-info">
                                                                <input id="statuss" type="radio" name="tipo" value="Sócio" {{ $User->cargo == 'Sócio' && $User->status == 'Ativo' ? 'checked' : '' }}>
                                                                <label for="statuss">Sócio</label>
                                                            </div>
                                                        </label>
                                                        <label class="radio-inline">
                                                            <div class="radio radio-info">
                                                                <input id="statusn" type="radio" name="tipo" value="Administrador" {{ $User->nivel == '1' ? 'checked' : '' }}>
                                                                <label for="statusn">Administrador</label>
                                                            </div>
                                                        </label>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="col-md-12">
                                                <button type="submit" class="btn btn-primary btn-sm"> <i class="fa fa-check"></i> Atualizar Perfil</button>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </section>
        </div>
    </div>

    <div class="modal fade modal_assinatura" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myLargeModalLabel">Criar Assinatura</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">Planos</label>
                                    <select id="produto_id" class="form-select">
                                        <option value="">Selecione um plano</option>
                                        {{-- @foreach ($produtos as $produto)
                                            <option value="{{ $produto->id }}">{{ $produto->nome }} - R$ {{ moeda($produto->preco) }}</option>
                                        @endforeach --}}
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-12">
                                            <div class="form-group">
                                                <label class="form-label">Próximo vencimento</label>
                                                <input id="proximo_vencimento" type="date" class="form-control date-time">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">Situação da assinatura</label>
                                    <div class="form-group">
                                        <div class="radio">
                                            <input name="status" type="radio" id="Option_1" checked="" value="Ativa">
                                            <label for="Option_1">Paga </label>
                                        </div>
                                        <div class="radio">
                                            <input name="status" type="radio" id="Option_2" value="Pendente de pagamento">
                                            <label for="Option_2">Pendente Gerar Boleto</label>
                                        </div>
                                        <div class="radio">
                                            <input name="status" type="radio" id="Option_3" value="Bonificação">
                                            <label for="Option_3">Bonificação</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger text-start btn-sm" data-bs-dismiss="modal">Cancelar</button>
                    <button onclick="javascript:IngressoStore()" type="button" class="btn btn-primary float-end btn-sm">Criar Assinatura</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <div class="modal fade modal_gerar_cobranca" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="myLargeModalLabel">Gerar Pagamento</h4>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <div class="box-body">
                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">Tipo</label>
                                    <select id="tipo" class="form-select">
                                        <option value="">Selecione um tipo</option>
                                        <option value="Assinatura">Assinatura</option>
                                        <option value="Avulsa">Avulsa</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12 d-none" id="box_descricao">
                                <div class="form-group">
                                    <label class="form-label">Descrição</label>
                                    <input name="descricao" id="descricao" type="text" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">Descrição</label>
                                    <select id="qtd_meses" class="form-select">
                                        <option value="">Selecione a quantidade</option>
                                        @for ($i = 1; $i < 12; $i++)
                                            <option value="{{ $i }}">{{ $i }}</option>
                                        @endfor
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">Opção adicional</label>
                                    <select id="opcao_adicional" class="form-select">
                                        <option value="">Selecione uma Opção</option>
                                        <option value="Separar Fatura">Separar Fatura</option>
                                        <option value="Mesclar Fatura">Mesclar Fatura</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label class="form-label">Vencimento</label>
                                    <input id="vencimento" type="date" class="form-control date-time">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-danger text-start btn-sm" data-bs-dismiss="modal">Cancelar</button>
                    <button onclick="javascript:NewInfoiceStore()" type="button" class="btn btn-primary float-end btn-sm">Criar Assinatura</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <div class="modal  center-modal fade boleto_modal_edit" tabindex="-1" role="dialog" aria-labelledby="myLargeModalLabel" aria-hidden="true" style="display: none;">
        <div class="modal-dialog" id="result_boleto">

        </div>
    </div>
@endsection
@section('js')
    <script src="{{ url('adm') }}/assets/vendor_plugins/iCheck/icheck.min.js"></script>


    <script src="{{ url('adm') }}/assets/vendor_components/sweetalert/sweetalert.min.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_components/sweetalert/jquery.sweet-alert.custom.js"></script>

    <script src="{{ url('adm') }}/assets/vendor_components/ckeditor/ckeditor.js"></script>
    <script src="{{ url('adm') }}/assets/vendor_plugins/bootstrap-wysihtml5/bootstrap3-wysihtml5.all.js"></script>
    <script src="{{ url('adm') }}/src/js/pages/editor.js"></script>

    <script>
        document.addEventListener("DOMContentLoaded", function() {
            function aplicarMascara(input, mascara) {
                input.addEventListener("input", function(e) {
                    let valor = input.value.replace(/\D/g, ""); // Remove tudo que não for número
                    let resultado = "";
                    let i = 0;

                    for (let char of mascara) {
                        if (char === "#") {
                            if (i < valor.length) {
                                resultado += valor[i++];
                            } else {
                                break;
                            }
                        } else {
                            if (i < valor.length || char === mascara[i]) {
                                resultado += char;
                            }
                        }
                    }

                    // Verifica se a tecla pressionada foi "Backspace" ou "Delete"
                    if (e.inputType === "deleteContentBackward" || e.inputType === "deleteContentForward") {
                        resultado = resultado.slice(0, -1); // Remove o último caractere
                    }

                    // Atualiza o valor do campo sem travar a remoção de caracteres
                    input.value = resultado;
                });
            }

            // Aplica máscaras nos campos
            aplicarMascara(document.querySelector("#cpf"), "###.###.###-##");
            aplicarMascara(document.querySelector("#nascimento"), "##/##/####");
            aplicarMascara(document.querySelector("#celular"), "(##) #####-####");
        });

        $(document).ready(function() {


            const inputsValores = document.querySelectorAll('.preco');
            inputsValores.forEach(function(inputValor) {
                inputValor.addEventListener('input', function(event) {
                    // Pega o valor do input e remove tudo que não é número
                    let valor = inputValor.value.replace(/\D/g, '');

                    // Formata o valor como dinheiro
                    if (valor) {
                        valor = (parseInt(valor) / 100).toLocaleString('pt-BR', {
                            style: 'currency',
                            currency: 'BRL'
                        });
                    } else {
                        valor = '';
                    }

                    // Atualiza o valor no input
                    inputValor.value = valor;
                });
            });

            const imageInput = document.getElementById('imageInput');
            const selectedImage = document.getElementById('selectedImage');

            imageInput.addEventListener('change', () => {
                const file = imageInput.files[0];
                const reader = new FileReader();

                reader.addEventListener('load', () => {
                    selectedImage.setAttribute('src', reader.result);
                });
                reader.readAsDataURL(file);
            });

            $("#cep").on("blur", function() {
                var numCep = $("#cep").val();
                var url = "https://viacep.com.br/ws/" + numCep.replace(/[\.-]/g, '') + "/json";
                $.ajax({
                    url: url,
                    type: "get",
                    dataType: "json",
                    success: function(dados) {
                        console.log(dados);
                        $("#cep").val(dados.cep);
                        $("#endereco").val(dados.logradouro);
                        $("#bairro").val(dados.bairro);
                        $("#cidade").val(dados.localidade);
                        $("#estado").val(dados.uf);
                    }
                });
            });
        });



        function BoletoShow(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "#",
                method: 'POST',
                data: {
                    id: id
                },
                success: function(result) {
                    $("#result_boleto").html(result);
                    $(".boleto_modal_edit").modal('show');
                },
                error: function(xhr, status, error) {
                    console.error("Erro na requisição:", error);
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }


        function AtualziarBoleto(id) {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "#",
                method: 'POST',
                data: {
                    id: id,
                    forma_pagamento: $("#forma_pagamento").val(),
                    status: $("#status").val(),
                    data_pago: $("#data_pago").val(),
                    vencimento: $("#vencimento_boleto").val(),
                    observacoes: $("#observacoes").val(),
                },
                success: function(result) {
                    $("#result_boletos").html(result);
                    $(".boleto_modal_edit").modal('hide');
                },
                error: function(xhr, status, error) {
                    console.error("Erro na requisição:", error);
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }

        @if (session('success'))
            swal(
                "Sucesso",
                "{{ session('success') }}",
                "success"
            );
        @endif

        function IngressoStore() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });

            $.ajax({
                url: "#",
                method: 'POST',
                data: {
                    id: {{ $User->id }},
                    status: $("input[name='status']:checked").val(),
                    proximo_vencimento: $("#proximo_vencimento").val(),
                    produto_id: $("#produto_id").val()
                },
                success: function(result) {
                    location.reload();
                },
                error: function(xhr, status, error) {
                    console.error("Erro na requisição:", error);
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }

        document.getElementById('tipo').addEventListener('change', function() {
            let boxDescricao = document.getElementById('box_descricao');
            if (this.value === 'Avulsa') {
                boxDescricao.classList.remove('d-none'); // Mostra o campo
            } else {
                boxDescricao.classList.add('d-none'); // Esconde o campo
            }
        });

        function NewInfoiceStore() {
            $.ajaxSetup({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                }
            });
            $.ajax({
                url: "#",
                method: 'POST',
                data: {
                    id: {{ $User->id }},
                    tipo: $("#tipo").val(),
                    descricao: $("#descricao").val(),
                    qtd_meses: $("#qtd_meses").val(),
                    opcao_adicional: $("#opcao_adicional").val(),
                },
                success: function(result) {
                    location.reload();
                },
                error: function(xhr, status, error) {
                    console.error("Erro na requisição:", error);
                    alert("Não foi possível atualizar o status. Tente novamente.");
                }
            });
        }
    </script>

@endsection
