@extends('admin.base.base')
@section('titulo', 'Auditoria de Vendas')
@section('content')
    <div class="content-wrapper">
        <div class="container-full">
            <div class="content-header">
                <div class="d-flex align-items-center">
                    <div class="me-auto">
                        <h4 class="page-title">Auditoria de Vendas</h4>
                    </div>
                    <div class="form-group"></div>
                </div>
            </div>
            <section class="content">
                <div class="row">
                    <form action="#" method="post">
                        @csrf
                        <input type="hidden" name="tipo" value="nfe">
                        <div class="box">
                            <div class="box-header">
                                <h4 class="box-title">Pesquisa de Vendas</h4>
                            </div>
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label">Evento</label>
                                            <select name="evento_id" class="form-select" id="localSelect">
                                                <option value="">Todos os eventos</option>
                                                @foreach ($eventos as $evento)
                                                    <option value="{{ $evento->id }}">{{ $evento->titulo }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label">Início</label>
                                            <input type="date" id="inicio" name="inicio" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label class="form-label">Fim</label>
                                            <input type="date" id="fim" name="fim" class="form-control">
                                        </div>
                                    </div>
                                </div>
                                <div class="box-footer text-end">
                                    <button type="button" class="btn btn-warning me-1 btn-sm" id="btn-limpar">
                                        <i class="ti-trash"></i> Limpar filtro
                                    </button>
                                    <button type="submit" class="btn btn-primary btn-sm">
                                        <i class="ti-save-alt"></i> Filtrar
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="col-sm-12">
                    <div class="box">
                        <div class="box-body">
                            <div class="table-responsive">
                                <table id="example" class="table table-hover display nowrap margin-top-10 w-p100">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Data</th>
                                            <th>Cliente</th>
                                            <th>Evento</th>
                                            <th>Ingressos</th>
                                            <th>Valor</th>
                                            <th>Forma Pagamento</th>
                                        </tr>
                                    </thead>
                                    <tbody id="tbody-notas">
                                        @foreach ($eventos as $pedido)
                                            <tr class="table-notas-body clickable">
                                                <td>
                                                    {{ $pedido->id }} <br>
                                                    {{ $pedido->Boleto->id }}
                                                </td>
                                                <td>{{ date('d/m/Y H:i', strtotime($pedido->created_at)) }}</td>
                                                <td>{{ $pedido->Cliente->id }}-{{ $pedido->Cliente->name }} {{ $pedido->Cliente->sobrenome }}</td>
                                                <td>{{ $pedido->Evento->titulo }}</td>
                                                <td>{{ $pedido->Evento->titulo }}</td>
                                                <td>R$ {{ moeda($pedido->total) }}</td>
                                                <td>{{ $pedido->forma_pagamento }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- /.content -->
        </div>
    </div>
    <!-- /.content-wrapper -->
@endsection
@section('js')
    <script src="{{ url('adm') }}/assets/vendor_components/datatable/datatables.min.js"></script>
    <script src="{{ url('adm') }}/src/js/pages/data-table.js"></script>
    <script></script>
@endsection
