numeral.locale('pt-br');

$(document).ready(function () {

    tippy('[data-tippy-content]');

    $('.text-img-fluid').find('img').addClass('img-fluid');

    $('.btnAplicarCodigo').click(function () {
        const input = $(this).closest('.trInputCodigo').find('input[name="codigo_desconto"]').first();
        const codigo = input.val();
        const currentUrl = new URL(window.location.href);
        currentUrl.searchParams.set('d', codigo);
        window.location.href = currentUrl.toString();
    });

    $('.input-codigo-promocional').on('keypress', function (e) {
        var code = e.keyCode || e.which;
        if (code == 13) {
            e.preventDefault();
            $('.btnAplicarCodigo').click();
        }
    });

    // used when has multiple modals opened
    $('body').on('hidden.bs.modal', function () {
        if ($('.modal.show').length > 0) {
            $('body').addClass('modal-open');
        }
    });
});

function showDiscountPanel() {
    $('.linkAplicarCodigo').hide();
    $('.trInputCodigo').show();
}

var cart_total = numeral(0);

function minus(qtd_auto_id) {
    qty = parseInt($('#' + qtd_auto_id).val());
    qty_available = parseInt($('#qty_label-' + qtd_auto_id).attr("data-available"));
    qty_min = parseInt($('#qty_label-' + qtd_auto_id).attr("data-min-qty"));
    total_amount = numeral($('#qty_label-' + qtd_auto_id).attr("data-total"));

    if (qty > 0) {
        qty -= qty_min;
        amount = total_amount.multiply(qty_min);
        cart_total = numeral(cart_total.subtract(amount.value()));
    }

    $('#' + qtd_auto_id).val(qty);
    $('#qty_label-' + qtd_auto_id).text(qty);
    $('.cart_total').html('R$ ' + cart_total.format('0,0.00'));

    if (cart_total.value() > 0) {
        $('.installments-free-label').show();
    } else {
        $('.installments-free-label').hide();
    }
}

function plus(qtd_auto_id) {
    qty = parseInt($('#' + qtd_auto_id).val());
    qty_available = parseInt($('#qty_label-' + qtd_auto_id).attr("data-available"));
    qty_min = parseInt($('#qty_label-' + qtd_auto_id).attr("data-min-qty"));
    total_amount = numeral($('#qty_label-' + qtd_auto_id).attr("data-total"));

    if (qty < qty_available) {
        qty += qty_min;
        amount = total_amount.multiply(qty_min);
        cart_total = numeral(cart_total.add(amount.value()));
    }

    $('#' + qtd_auto_id).val(qty);
    $('#qty_label-' + qtd_auto_id).text(qty);
    $('.cart_total').html('R$ ' + cart_total.format('0,0.00'));

    if (cart_total.value() > 0) {
        $('.installments-free-label').show();
    } else {
        $('.installments-free-label').hide();
    }
    $('.table-cart-total').show();
}

