$(document).ready(function () {



    $('#btnFinalizar').click(function () {

        let payment_method = $('input[name="payment_method"]:checked').val();

        if (payment_method == 'CC' || payment_method == 'B') {

            $('#posCep').show();

        }



        if ($('#form_pedido')[0].checkValidity()) {

            $('#form_pedido').submit();

        } else {

            $('#form_pedido')[0].reportValidity();

        }

    }); 



    $('#form_pedido').submit(function (event) {

        event.preventDefault();

        $('#loader').show();

        $('#formError').remove();

        $('#form_pedido input').removeClass('field-error');

        $('#btnFinalizar').prop('disabled', true);



        if (gatewayCredit == 'mercado_pago') {

            run_mercado_pago();



        } else if (gatewayCredit == 'pagbank') {

            run_pagbank();



        } else {

            run_checkout();

        }

    });



    run_mercado_pago = async function () {

        let payment_method = $('input[name="payment_method"]:checked').val();

        if (payment_method == 'CC') {



            const mp = new MercadoPago($('#id_public_key').val());



            let identificationType = 'CPF';

            const identificationNumber = $('#id_holder_cpf_cnpj').val().match(/\d+/g).join('');



            if (identificationNumber.length == 14) {

                identificationType = 'CNPJ';

            }



            let cardNumber = cleanCardNumber();

            if (cardNumber == false) {

                return false;

            }



            try {

                const cardToken = await mp.createCardToken({

                    cardNumber: cardNumber,

                    cardholderName: $('#id_holder_name').val(), 

                    cardExpirationMonth: $('#id_expiration').val().split('/')[0],

                    cardExpirationYear: '20' + $('#id_expiration').val().split('/')[1],

                    securityCode: $('#id_cvv').val(),

                    identificationType: identificationType,

                    identificationNumber: identificationNumber,

                });

                $('#id_hash').val(cardToken['id']);



            } catch (error) {

                try {

                    if (error.hasOwnProperty('status') && error['status'] == 400) {



                        switch (error['message']) {

                            case 'invalid expiration_month':

                            case 'invalid expiration_year':

                                return expirationError();

                            case 'invalid security_code':

                                return cvvError();

                        }



                    } else if (Array.isArray(error)) {



                        switch (error[0]['code']) {

                            case '325':

                            case '326':

                                return expirationError();

                            case 'E301':

                                return cardNumberError();

                            case 'E302':

                                return cvvError();

                            case '324':

                                return holderCpfCnpjError();

                            case '316':

                                return holderNameError();

                        }

                    }



                    return mpError();



                } catch (error) {

                    console.log(error);

                    return mpError();

                }

            }



            try {

                const paymentMethods = await mp.getPaymentMethods({ bin: cardNumber.substr(0, 6) });

                if (paymentMethods['results'].length > 0) {

                    $('#id_card_brand').val(paymentMethods['results'][0]['id']);

                } else {

                    return cardNumberError();

                }

            } catch (error) {

                console.log(error);

                return mpError();

            }

            run_checkout();

        } else {

            run_checkout();

        }

    };



    run_pagbank = function () {

        let payment_method = $('input[name="payment_method"]:checked').val();

        if (payment_method == 'CC') {



            let cardNumber = cleanCardNumber();

            if (cardNumber == false) {

                return false;

            }



            const card = PagSeguro.encryptCard({

                publicKey: $('#id_public_key').val(),

                holder: $('#id_holder_name').val().trim().replace(/\s+/g, ' '),

                number: cardNumber,

                expMonth: $('#id_expiration').val().split('/')[0],

                expYear: '20' + $('#id_expiration').val().split('/')[1],

                securityCode: $('#id_cvv').val()

            });



            $('#id_hash').val(card.encryptedCard);

            const hasErrors = card.hasErrors;

            const errors = card.errors;



            if (hasErrors) {

                errors.forEach(function (item) {



                    switch (item['code']) {

                        case 'INVALID_NUMBER':

                            return cardNumberError();

                        case 'INVALID_SECURITY_CODE':

                            return cvvError();

                        case 'INVALID_EXPIRATION_MONTH':

                        case 'INVALID_EXPIRATION_YEAR':

                            return expirationError();

                        case 'INVALID_HOLDER':

                            return holderNameError();

                        case 'INVALID_PUBLIC_KEY':

                            return publicKeyError();

                    }



                })

            } else {

                run_3ds_pagbank();

            }



        } else {

            run_checkout();

        }

    };



    run_3ds_pagbank = function () {



        $.ajax({

            type: 'POST', url: urlGet3dsPaymentData, data: {}, beforeSend: function (xhr) {

                xhr.setRequestHeader("X-CSRFToken", Cookies.get('csrftoken'));

            },

        }).done(function (rs) {



            PagSeguro.setUp({

                session: rs.session,

                env: environment

            });



            const installmentsData = JSON.parse(document.getElementById('installments-data').textContent);

            const numberInstallments = $('#id_number_installments').val();

            let totalAmount;



            installmentsData.forEach(function (item) {

                if (item['quantity'] == numberInstallments) {

                    totalAmount = parseInt(item['total_amount'].replaceAll('.', ''));

                }

            })



            const request = {

                data: {

                    customer: {

                        name: $('#id_nome_completo').val().trim().replace(/\s+/g, ' '),

                        email: $('#id_email').val(),

                        phones: [

                            {

                                country: '55',

                                area: $('#id_phone_number').val().replace(/\D/g, '').substring(0, 2),

                                number: $('#id_phone_number').val().replace(/\D/g, '').substring(2),

                                type: 'MOBILE'

                            }

                        ]

                    },

                    paymentMethod: {

                        type: 'CREDIT_CARD',

                        installments: parseInt(numberInstallments),

                        card: {

                            encrypted: $('#id_hash').val()

                        }

                    },

                    amount: {

                        value: totalAmount,

                        currency: 'BRL'

                    },

                    billingAddress: {

                        street: $('#id_logradouro').val(),

                        number: $('#id_numero').val(),

                        complement: $('#id_bairro').val() + " " + $('#id_complemento').val(),

                        regionCode: $('#id_uf').val(),

                        country: 'BRA',

                        city: $('#id_cidade').val(),

                        postalCode: $('#id_cep').val().replace(/\D/g, "")

                    },

                    dataOnly: false

                }

            }



            PagSeguro.authenticate3DS(request).then(result => {



                console.log(result);



                switch (result.status) {

                    case 'CHANGE_PAYMENT_METHOD':

                        // The user must change the payment method used

                        pagBank3DSDenied();

                        unblock();

                        return false;



                    case 'AUTH_FLOW_COMPLETED':

                        // O processo de autenticaÃ§Ã£o foi realizado com sucesso, dessa forma foi gerado um id do 3DS que poderÃ¡ ter o resultado igual a Autenticado ou NÃ£o Autenticado.

                        if (result.authenticationStatus === 'AUTHENTICATED') {

                            // O cliente foi autenticado com sucesso, dessa forma o pagamento foi autorizado.

                            $('#id_threeds_auth_id').val(result.id);

                            run_checkout();

                            console.debug('PagBank: 3DS Autenticado ou Sem desafio');

                            return true;

                        } else {

                            alert('AutenticaÃ§Ã£o 3DS falhou. Tente novamente.');

                            unblock();

                            return false;

                        }



                    case 'AUTH_NOT_SUPPORTED':

                        // A autenticaÃ§Ã£o 3DS nÃ£o ocorreu, isso pode ter ocorrido por falhas na comunicaÃ§Ã£o com emissor ou bandeira, ou algum controle que nÃ£o possibilitou a geraÃ§Ã£o do 3DS id, essa transaÃ§Ã£o nÃ£o terÃ¡ um retorno de status de autenticaÃ§Ã£o e seguirÃ¡ como uma transaÃ§Ã£o sem 3DS.

                        // O cliente pode seguir adiante sem 3Ds (exceto dÃ©bito)

                        console.debug('PagBank: 3DS nÃ£o suportado pelo cartÃ£o. Continuando sem 3DS.');

                        run_checkout();

                        return true;



                    case 'REQUIRE_CHALLENGE':

                        // Ã‰ um status intermediÃ¡rio que Ã© retornando em casos que o banco emissor solicita desafios, Ã© importante para identificar que o desafio deve ser exibido.

                        console.debug('PagBank: REQUIRE_CHALLENGE - O desafio estÃ¡ sendo exibido pelo banco.');

                        break;

                }



            }).catch((err) => {

                if (err instanceof PagSeguro.PagSeguroError) {

                    console.error(err);

                    console.debug('PagBank: ' + err.detail);

                    let errMsgs = err.detail.errorMessages.map(error => pagBankParseErrorMessage(error)).join('\n');

                    exibeErros({ "erros": { "formIngressosGeral": ["Falha na requisiÃ§Ã£o de autenticaÃ§Ã£o 3D.", errMsgs] } });

                    unblock();

                }

            })



        }).fail(function () {

            alert('PagBank 3DS: Ocorreu um erro ao processar o pedido em nosso sistema!');

            unblock();

        });



    }



    run_checkout = function () {

        checkSingleTicket();

        const form_data_serialize = $("#form_pedido [name]").not('#id_card_number,#id_cvv').serialize();



        $.ajax({

            type: 'POST', url: urlPedidoConfirm, data: form_data_serialize, beforeSend: function (xhr) {

                xhr.setRequestHeader("X-CSRFToken", Cookies.get('csrftoken'));

            },

        }).done(function (rs) {



            if (rs.erros) {

                exibeErros(rs);



            } else {

                if (rs.three_ds_info) {

                    sessionStorage.setItem("num_pedido", rs.num_pedido);

                    doChallenge(rs.three_ds_info);

                    $('#loader').hide();

                } else {

                    window.location.replace(rs.redirect_url);

                }

            }



        }).fail(function () {

            alert('Ocorreu um erro ao processar o pedido em nosso sistema!');

            unblock();

        });

    };



    doChallenge = function (three_ds_info) {

        const external_resource_url = three_ds_info.external_resource_url;

        const creq = three_ds_info.creq;



        var iframe = document.createElement("iframe");

        iframe.name = "mp_frame";

        iframe.id = "mp_frame";

        iframe.height = "500px";

        iframe.width = "500px";

        iframe.style = "border:0px";

        document.getElementById('modalBodyChallenge').appendChild(iframe);



        var idocument = iframe.contentWindow.document;



        var myform = idocument.createElement("form");

        myform.name = "myform";

        myform.setAttribute("target", "mp_frame");

        myform.setAttribute("method", "post");

        myform.setAttribute("action", external_resource_url);



        var hiddenField = idocument.createElement("input");

        hiddenField.setAttribute("type", "hidden");

        hiddenField.setAttribute("name", "creq");

        hiddenField.setAttribute("value", creq);

        myform.appendChild(hiddenField);

        iframe.appendChild(myform);



        myform.submit();

        $('#modalChallenge').modal('show');

        $('#modalChallenge').modal('handleUpdate');



        window.addEventListener("message", (e) => {

            if (e.data.status === "COMPLETE") {

                checkChallenge();

            }

        });

    }



    let counterCheck3dsPayment = 1;



    checkChallenge = function () {

        $('#loader').show();



        const num_pedido = sessionStorage.getItem("num_pedido");



        $.ajax({

            type: 'POST', url: urlCheck3dsPayment, data: { "num_pedido": num_pedido }, beforeSend: function (xhr) {

                xhr.setRequestHeader("X-CSRFToken", Cookies.get('csrftoken'));

            },

        }).done(function (rs) {

            counterCheck3dsPayment += 1;



            if (rs.success) {

                window.location.replace(rs.redirect_url);



            } else {

                if (counterCheck3dsPayment <= 3) {

                    setTimeout(checkChallenge, 3000);

                } else {

                    window.location.replace(rs.redirect_url);

                }

            }



        }).fail(function () {

            alert('Ocorreu um erro ao processar o pedido em nosso sistema!');

            $('#loader').hide();

        });

    };



    checkSingleTicket = function () {

        if ($('#id_form-0-nome_completo').is('[type="hidden"]') == true) {

            $('#id_form-0-nome_completo').val($('#id_nome_completo').val());

            $('#id_form-0-email').val($('#id_email').val());

        }

    }



    cleanCardNumber = function () {

        let cardNumber = $('#id_card_number').val().match(/\d+/g);

        if (Array.isArray(cardNumber)) {

            return cardNumber.join('');

        } else {

            return cardNumberError();

        }

    }



    expirationError = function () {

        rs = { "erros": { "formCC": { "expiration": ["Data de expiraÃ§Ã£o do cartÃ£o invÃ¡lida."] } } };

        exibeErros(rs);

        return false;

    };



    cardNumberError = function () {

        rs = { "erros": { "formCC": { "card_number": ["NÃºmero do cartÃ£o de crÃ©dito invÃ¡lido."] } } };

        exibeErros(rs);

        return false;

    };



    cvvError = function () {

        rs = { "erros": { "formCC": { "cvv": ["CÃ³digo de seguranÃ§a do cartÃ£o invÃ¡lido."] } } };

        exibeErros(rs);

        return false;

    };



    holderCpfCnpjError = function () {

        rs = { "erros": { "formCC": { "holder_cpf_cnpj": ["CPF/CNPJ do titular do cartÃ£o invÃ¡lido."] } } };

        exibeErros(rs);

        return false;

    };



    holderNameError = function () {

        rs = { "erros": { "formCC": { "holder_name": ["Nome (impresso no cartÃ£o) invÃ¡lido."] } } };

        exibeErros(rs);

        return false;

    };



    phoneNumberError = function () {

        rs = { "erros": { "formCC": { "telefone": ["NÃºmero de telefone invÃ¡lido."] } } };

        exibeErros(rs);

        return false;

    };



    publicKeyError = function () {

        alert('Chave pÃºblica invÃ¡lida. Atualize a pÃ¡gina e tente novamente.')

        $('#loader').hide();

        return false;

    };



    pagBank3DSDenied = function () {

        rs = { "erros": { "formCC": { "card_number": ["Pagamento negado pelo PagBank. Escolha outro mÃ©todo de pagamento ou cartÃ£o."] } } };

        exibeErros(rs);

        return false;

    };



    mpError = function () {

        alert('Ocorreu um erro ao processar os dados do cartÃ£o. Verifique os dados e tente novamente.')

        unblock();

        return false;

    };



    unblock = function () {

        $('#loader').hide();

        $('#btnFinalizar').prop('disabled', false);

    }



    pagBankParseErrorMessage = function (errorMessage) {

        const codes = {

            '40001': 'ParÃ¢metro obrigatÃ³rio',

            '40002': 'ParÃ¢metro invÃ¡lido',

            '40003': 'ParÃ¢metro desconhecido ou nÃ£o esperado',

            '40004': 'Limite de uso da API excedido',

            '40005': 'MÃ©todo nÃ£o permitido',

        };



        const descriptions = {

            "must match the regex: ^\\p{L}+['.-]?(?:\\s+\\p{L}+['.-]?)+$": 'parece invÃ¡lido ou fora do padrÃ£o permitido',

            'cannot be blank': 'nÃ£o pode estar em branco',

            'size must be between 8 and 9': 'deve ter entre 8 e 9 caracteres',

            'must be numeric': 'deve ser numÃ©rico',

            'must be greater than or equal to 100': 'deve ser maior ou igual a 100',

            'must be between 1 and 24': 'deve ser entre 1 e 24',

            'only ISO 3166-1 alpha-3 values are accepted': 'deve ser um cÃ³digo ISO 3166-1 alpha-3',

            'either paymentMethod.card.id or paymentMethod.card.encrypted should be informed': 'deve ser informado o cartÃ£o de crÃ©dito criptografado ou o id do cartÃ£o',

            'must be an integer number': 'deve ser um nÃºmero inteiro',

            'card holder name must contain a first and last name': 'o nome do titular do cartÃ£o deve conter um primeiro e Ãºltimo nome',

            'card expiration date is expired': 'a data de validade do cartÃ£o expirou',

            'must be a well-formed email address': 'deve ser um endereÃ§o de e-mail vÃ¡lido',

        };



        const parameters = {

            'amount.value': 'valor do pedido',

            'customer.name': 'nome do cliente',

            'customer.phones[0].number': 'nÃºmero de telefone do cliente',

            'customer.phones[0].area': 'DDD do telefone do cliente',

            'billingAddress.complement': 'complemento/bairro do endereÃ§o de cobranÃ§a',

            'billingAddress.country': 'paÃ­s de cobranÃ§a',

            'billingAddress.postalCode': 'CEP',

            'paymentMethod.installments': 'parcelas',

            'paymentMethod.card': 'cartÃ£o de crÃ©dito',

            'paymentMethod.card.encrypted': 'cartÃ£o de crÃ©dito criptografado',

            'customer.email': 'e-mail',

        };



        // Get the code, description, and parameterName from the errorMessage object

        const { code, description, parameterName } = errorMessage;



        // Look up the translations

        const codeTranslation = codes[code] || code;

        const descriptionTranslation = descriptions[description] || description;

        const parameterTranslation = parameters[parameterName] || parameterName;



        // Concatenate the translations into a single string

        return `${codeTranslation}: ${parameterTranslation} - ${descriptionTranslation}`;

    }



});





