let gRecaptchaVersion = "v3";
var gRecaptchaLoginWidget;
var gRecaptchaRecoverWidget;
var gRecaptchaCreateAccountWidget;

function checkAuthenticated(is_auth) {
    if (is_auth) {
        $('#login-btn-dt').removeClass("d-md-block");
        $('#user-menu-dt').addClass("d-md-block");

        $('#user-menu-mb').show();
        $('#login-btn-mb').hide();

        $('.login-menu-footer').parent().remove();
    }
}

$(document).ready(function () {

    // checkAuthenticated(isAuthenticated);

    $('#loginForm').submit(function (event) {
        event.preventDefault();
        $('#loader').show();
        $('#loginBtn').prop('disabled', true);
        $('.login-error').html("");

        // if (gRecaptchaVersion == "v3") {
        //     grecaptcha.ready(function () {
        //         grecaptcha.execute(GOOGLE_RECAPTCHA_V3_PUBLIC_KEY, { action: 'submit' }).then(function (token) {
        //             $('#g_recaptcha_response').val(token);
        //             login();
        //         });
        //     });
        // } else {
        //     login();
        // }
    });



    $('#formRecoverPassword').submit(function (event) {
        event.preventDefault();
        $('#loader').show();
        $('.recover-error').html();
        $('#btnRecoverPassword').prop('disabled', true);

        $.ajax({
            type: 'POST', url: $('#formRecoverPassword').prop('action'), data: $("#formRecoverPassword").serialize(), beforeSend: function (xhr) {
                xhr.setRequestHeader("X-CSRFToken", csrftoken);
            },
        }).done(function (rs) {
            $('#recoverPasswordModal').modal('hide');
            $('#recoverPasswordSuccessModal').modal('show');
            $('#loader').hide();
            $('#btnRecoverPassword').prop('disabled', false);

        }).fail(function (rs) {
            if (rs.responseJSON) {
                $('.recover-error').html(rs.responseJSON['errors']);
                $('.recover-error').show();

            } else if (rs.status == 403) {
                $('.recover-error').html("Ocorreu um erro na validação de segurança. Favor atualizar a página e tentar novamente.");
                $('.recover-error').show();
            }
            grecaptcha.reset(gRecaptchaRecoverWidget);
            $('#loader').hide();
            $('#btnRecoverPassword').prop('disabled', true);
        });
    });

    if ($('#createAccountForm').length > 0) {
        $('#createAccountForm').submit(function (event) {
            event.preventDefault();
            $('#loader').show();
            $('.signup-error').html('');
            $('#createAccountBtn').prop('disabled', true);

            $.ajax({
                type: 'POST', url: $('#createAccountForm').prop('action'), data: $("#createAccountForm").serialize(), beforeSend: function (xhr) {
                    xhr.setRequestHeader("X-CSRFToken", csrftoken);
                },
            }).done(function (rs) {
                $('#createAccountModal').modal('hide');
                $('#createAccountCheckEmailModal').modal('show');
                $('#loader').hide();

                const pathname = window.location.pathname;
                if (pathname.endsWith("/checkout/")) {
                    $('input[name="csrfmiddlewaretoken"]').val(Cookies.get('csrftoken'));

                    if ($('#id_form-0-nome_completo').val() == "") {
                        $('#id_form-0-nome_completo').val(rs.full_name);
                        $('#id_form-0-email').val(rs.email);
                    }

                    $('#id_nome_completo').val(rs.full_name);
                    $('#id_email').val(rs.email);
                    $('#id_confirm_email').val(rs.email);
                }

            }).fail(function (rs) {
                if (rs.responseJSON) {
                    var errors = rs.responseJSON['errors'];
                    var str_errors = '';
                    for (var error in errors) {
                        if (Array.isArray(errors[error])) {
                            for (var e in errors[error]) {
                                str_errors += errors[error][e] + '<br>';
                            }
                        } else {
                            str_errors += errors[error] + '<br>';
                        }
                    }
                    $('.signup-error').html(str_errors);
                    $('.signup-error').show();

                } else if (rs.status == 403) {
                    $('.signup-error').html("Ocorreu um erro na validação de segurança. Favor atualizar a página e tentar novamente.");
                    $('.signup-error').show();
                }
                grecaptcha.reset(gRecaptchaCreateAccountWidget);
                $('#loader').hide();
                $('#createAccountBtn').prop('disabled', true);
            });
        });

        $('#createAccountCheckEmailModal').on('hidden.bs.modal', function (event) {
            if ($('#loginModal').length) {
                $('#loginModal').modal('show');
            } else {
                window.location.replace(login_url);
            }
        });
    }




});

function openLoginModal(createAccountModal = false) {
    if (createAccountModal == false) {
        $('#loginModal').modal('show');
    } else {
        $('#createAccountModal').modal('show');
    }

    google.accounts.id.initialize({
        client_id: GOOGLE_OAUTH_CLIENT_ID,
        callback: googleLoginCallback
    });

    google.accounts.id.renderButton(
        document.getElementById("googleSignin"),
        { theme: "filled_blue", size: "large" }
    );

    google.accounts.id.renderButton(
        document.getElementById("googleSignup"),
        { theme: "filled_blue", size: "large", text: "continue_with" }
    );

    google.accounts.id.prompt();
}

function loginDone(rs) {
    const pathname = window.location.pathname;

    if (pathname.endsWith("/checkout/")) {
        loginSuccessCheckout(rs);

    } else if (['/criar-conta/', '/admin/login/'].includes(pathname)) {
        window.location.replace(rs.next);

    } else {
        loginSuccessEvent(rs);
    }
}

function googleLoginCallback(response) {
    $('#loader').show();
    const parsedUrl = new URL(window.location.href);
    const nextValue = parsedUrl.searchParams.get("next");

    $.ajax({
        type: 'POST', url: '/web-login/google/', data: { "credential": response.credential, "next": nextValue }, beforeSend: function (xhr) {
            xhr.setRequestHeader("X-CSRFToken", csrftoken);
        },
    }).done(function (rs) {
        if (rs.success) {
            loginDone(rs);
        }
        $('#loader').hide();
    }).fail(function (error) {
        $('#loader').hide();
    });
}

function loginSuccessEvent(rs) {
    $('#loginModal').modal('hide');
    $('#loader').hide();

    $('#myAccountModal').modal('show');
    $('#myAccountModalLabel').text(`Olá ${rs.user_data.first_name}.`);

    if (rs.show_my_events_button) {
        $('#myEventsBtn').show();
    }

    $('.user-first-name').text(rs.user_data.first_name);
    checkAuthenticated(true);
    $('input[name="csrfmiddlewaretoken"]').val(Cookies.get('csrftoken'));
}

function loginSuccessCheckout(rs) {
    $('#loginModal').modal('hide');
    $('#loader').hide();

    $('#alertLogin').remove();
    $('.user-first-name').text(rs.user_data.first_name);
    checkAuthenticated(true);
    $('input[name="csrfmiddlewaretoken"]').val(Cookies.get('csrftoken'));

    if ($('#id_form-0-nome_completo').val() == "") {
        $('#id_form-0-nome_completo').val(rs.user_data.full_name);
        $('#id_form-0-email').val(rs.user_data.email);
    }

    $('#id_nome_completo').val(rs.user_data.full_name);
    $('#id_email').val(rs.user_data.email);
    $('#id_confirm_email').val(rs.user_data.email);
    $('#id_cpf_cnpj').val(rs.user_data.cpf_cnpj);
    $('#id_phone_number').val(rs.user_data.telefone);
    $('#id_cep').val(rs.user_data.cep);
    $('#id_logradouro').val(rs.user_data.logradouro);
    $('#id_numero').val(rs.user_data.numero);
    $('#id_complemento').val(rs.user_data.complemento);
    $('#id_bairro').val(rs.user_data.bairro);
    $('#id_cidade').val(rs.user_data.cidade);
    $('#id_uf').val(rs.user_data.uf);

    if (rs.user_data.first_name == '' || rs.user_data.last_name == '') {
        $('#id_email, #id_confirm_email').attr('readonly', true);
    } else {
        $('#id_nome_completo, #id_email, #id_confirm_email').attr('readonly', true);
    }
}
