// js/carousel.js
(function () {
  // 1) pega o trilho do carrossel (primeiro container com these classes)
  const track = document.querySelector("section .overflow-hidden.w-full.relative .flex.transition-all.duration-700.h-full");
  if (!track) return;

  const slides = Array.from(track.children);
  let index = 0;
  const DURA = 700; // ms - deve casar com duration-700
  const INTERVAL = 5000; // ms - tempo entre slides

  // 2) posiciona no primeiro slide
  function goTo(i) {
    index = (i + slides.length) % slides.length;
    track.style.transform = `translateX(-${index * 100}%)`;
  }
  // zera qualquer transform inline inicial
  track.style.willChange = "transform";
  track.style.transition = "transform 700ms ease";

  // 3) autoplay
  let timer = setInterval(() => goTo(index + 1), INTERVAL);

  // 4) controla setas (pega os botões com ícones na borda direita inferior)
  const rightBtn = document.querySelector(".lucide-chevron-right")?.closest("button");
  const leftBtn = document.querySelector(".lucide-chevron-left")?.closest("button");

  function resetTimer() {
    clearInterval(timer);
    timer = setInterval(() => goTo(index + 1), INTERVAL);
  }

  leftBtn &&
    leftBtn.addEventListener("click", () => {
      goTo(index - 1);
      resetTimer();
    });
  rightBtn &&
    rightBtn.addEventListener("click", () => {
      goTo(index + 1);
      resetTimer();
    });

  // 5) pausa ao passar o mouse no carrossel (desktop)
  const wrapper = track.parentElement;
  if (wrapper) {
    wrapper.addEventListener("mouseenter", () => clearInterval(timer));
    wrapper.addEventListener("mouseleave", resetTimer);
  }

  // 6) navegação pelos números (01, 02, 03...)
  document.querySelectorAll(".jsx-efe9363318f3e1c button h1").forEach((el) => {
    const num = parseInt(el.textContent, 10);
    if (!isNaN(num)) {
      el.parentElement.addEventListener("click", () => {
        goTo(num - 1);
        resetTimer();
      });
    }
  });

  // inicia no 0
  requestAnimationFrame(() => goTo(0));
})();
