<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Fortify\TwoFactorAuthenticatable;
use Laravel\Jetstream\HasProfilePhoto;
use Laravel\Jetstream\HasTeams;
use Laravel\Sanctum\HasApiTokens;

class User extends Authenticatable
{
    use HasApiTokens;
    use HasFactory;
    use HasProfilePhoto;
    use HasTeams;
    use Notifiable;
    use TwoFactorAuthenticatable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'user_import_id',
        'associado_id',
        'produtor_id',
        'asaas_id',
        'saldo',
        'matricula',
        'tipo_matricula',
        'nivel',
        'status',
        'name',
        'sobrenome',
        'email',
        'foto',
        'celular',
        'cpf',
        'rg',
        'nascimento',
        'sexo',
        'cep',
        'endereco',
        'numero',
        'complemento',
        'bairro',
        'cidade',
        'estado',
        'password',
        'token',
        'notification_email',
        'notification_whatsapp',
        'verificar_email',
        'verificar_whatsapp',
        'data_filiacao'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
        'two_factor_recovery_codes',
        'two_factor_secret',
    ];

    /**
     * The accessors to append to the model's array form.
     *
     * @var array<int, string>
     */
    protected $appends = [
        'profile_photo_url',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }

    public function Ingressos()
    {
        return $this->hasMany(Ingresso::class, 'user_id', 'id');
    }

    public function Pedidos()
    {
        return $this->hasMany(Pedido::class, 'user_id', 'id')->orderby('id', 'desc');
    }

    function pushToken()
    {
        return $this->hasMany(TokenPush::class, 'user_id', 'id');
    }

    function Analytics()
    {
        return $this->hasMany(Analytics::class, 'user_id', 'id');
    }

    public function Indicacoes()
    {
        return $this->hasMany(Pedido::class, 'divulgador_id', 'id');
    }

    public function Carteiras()
    {
        return $this->hasMany(Pedido::class, 'user_id', 'id');
    }

    function Permissoes()
    {
        return $this->hasMany(RuleApp::class, 'user_id', 'id');
    }
}
