<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EventoColaborador extends Model
{
    use HasFactory;

    protected $fillable = [
        'evento_id',
        'nivel',
        'user_id',
    ];

    public function User()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    public function Pacotes()
    {
        return $this->hasMany(EventoEventoColaboradorPacote::class, 'evento_colaborador_id', 'id');
    }

    public function Evento()
    {
        return $this->belongsTo(Evento::class, 'evento_id');
    }
}
