<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Email extends Model
{
    use HasFactory;

    protected $fillable = [
        'evento_id',
        'user_id',
        'assunto',
        'msg',
        'link_final'
    ];

    function Anexos()
    {
        return $this->hasMany(EmailAnexos::class, 'email_id', 'id');
    }

    function Remetente()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }

    function Respostas()
    {
        return $this->hasMany(EmailResposta::class, 'email_id', 'id');
    }

    function Destinatarios()
    {
        return $this->hasMany(EmailDestinatario::class, 'email_id', 'id');
    }


    function Anexo()
    {
        return $this->hasOne(EmailAnexos::class, 'email_id', 'id');
    }

    function Evento()
    {
        return $this->hasOne(Evento::class, 'id', 'email_id');
    }
}
