<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Boleto extends Model
{
    use HasFactory;
    protected $fillable = [
        'getway_id',
        'pedido_id',
        'user_id',
        'payment_id',
        'asaas_id',
        'asaas_checkout',
        'asaas_boleto',
        'qr_code',
        'cod_pix',
        'link_ticket',
        'status',
        'status_cron',
        'status_comissao',
        'valor',
        'ref',
        'vencimento',
        'data_pago',
        'taxa_lopak',
        'taxa_banco',
        'pdv',
        'verificado',
        'notificado',
        'forma_pagamento',
        'observacoes',
    ];



    public function Cliente()
    {
        return $this->hasOne(User::class, 'id', 'user_id');
    }
    public function Pedido()
    {
        return $this->hasOne(Pedido::class, 'id', 'pedido_id');
    }

    public function Assinatura()
    {
        return $this->hasOne(Pedido::class, 'id', 'pedido_id')->where('tipo', 'Assinaturas');
    }
}
