<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Session\TokenMismatchException;

class HandlePageExpired
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure  $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        try {
            return $next($request);
        } catch (TokenMismatchException $exception) {
            // Redireciona para a página de login com uma mensagem de erro
            return redirect('login')->with('error', 'Sua sessão expirou. Por favor, faça o login novamente.');
        }
    }
}
