<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;
use App\Models\EventoColaborador;

class CheckUserLevel
{
    public function handle(Request $request, Closure $next): Response
    {
        if (!Auth::check()) {
            return redirect('/')->with('error', 'Acesso não autorizado.');
        }

        $user = Auth::user();

        if (!in_array($user->nivel, [1, 2])) {
            return redirect('/')->with('error', 'Acesso não autorizado.');
        }

        // Se for produtor (nível 2), checa se tem permissão no evento da rota
        if ($user->nivel == '2') {
            $evento = $request->route('Evento'); // geralmente é tudo minúsculo
            // dd($user,$evento);
            if ($evento) {
                $autorizado = EventoColaborador::where('evento_id', $evento->id)
                    ->where('user_id', $user->id)
                    ->exists();

                if (!$autorizado) {
                    return redirect()->route('dashboard')->with('error', 'Esse evento não pertence a você.');
                }
            }
        }

        return $next($request);
    }
}
