<?php

namespace App\Http\Controllers;

use App\Models\Evento;
use App\Models\Ingresso;
use App\Models\TokenPush;
use App\Models\User;
use Illuminate\Http\Request;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Auth;

class PushController extends Controller
{

    private $accessToken;

    public function __construct()
    {
        $this->accessToken = env('EXPO_ACCESS_TOKEN'); // Pegue o token do .env
    }

    public function sendNotification(Request $request)
    {
        // Valide os parâmetros recebidos
        $validatedData = $request->validate([
            'expoPushToken' => 'required|string',
            'title' => 'required|string',
            'body' => 'required|string',
            'data' => 'nullable|array',
        ]);

        $expoPushToken = $validatedData['expoPushToken'];
        $title = $validatedData['title'];
        $body = $validatedData['body'];
        $data = $validatedData['data'] ?? [];

        $client = new Client();
        $url = 'https://exp.host/--/api/v2/push/send';
        $headers = [
            'Accept' => 'application/json',
            'Content-Type' => 'application/json',
            'Authorization' => 'Bearer ' . $this->accessToken,
        ];

        $payload = [
            'to' => $expoPushToken,
            'sound' => 'default',
            'title' => $title,
            'body' => $body,
            'data' => !empty($data) ? $data : new \stdClass(),
        ];

        try {
            $response = $client->post($url, [
                'headers' => $headers,
                'json' => $payload,
            ]);

            $result = json_decode($response->getBody(), true);
            return response()->json(['success' => true, 'result' => $result]);
        } catch (\Exception $e) {
            return response()->json(['success' => false, 'error' => $e->getMessage()], 500);
        }
    }

    protected function sendPushNotification($expoPushToken, $title, $body, $data = [])
    {
        $pushController = app(PushController::class);
        $request = new Request([
            'expoPushToken' => $expoPushToken,
            'title' => $title,
            'body' => $body,
            'data' => $data,
        ]);

        $pushController->sendNotification($request);
    }

    public function push()
    {
        $array  = ['error' => ''];
        $tokens = TokenPush::get();
        foreach ($tokens as $push) {
            if ($push->token) {
                $this->sendPushNotification(
                    $push->token,
                    'UCESUB',
                    'É hoje! Halloween do Inferninho no Horto Louge. Corra e garanta seu ingresso sem filas!',
                    [
                        'screen' => 'EventoIndex',
                        'params' => ['evento' => [
                            'id' => 134
                        ]]
                    ]
                );
            }
        }
        return $array;
    }

    public function PushAlertaEventoComprado($evento_id)
    {
        $array  = ['error' => ''];

        $ingressos = Ingresso::where('evento_id', $evento_id)->get();
        foreach ($ingressos as $ingresso) {
            if (count($ingresso->Cliente->pushToken) > 0) {
                foreach ($ingresso->Cliente->pushToken as $push) {
                    if ($push->token) {
                        $this->sendPushNotification(
                            $push->token,
                            '🎉 Ei, ' . $ingresso->Cliente->name . ' Chegou o grande dia!',
                            'Hoje tem 3030 – Voz e Violão e a vibe vai ser incrível! Seu ingresso tá no app da UCESUB — e pode ficar tranquilo, ele funciona mesmo offline! Agora é só chegar e curtir! 💃🕺',
                            [
                                'evento_id'  => 22,
                            ]
                        );
                    }
                }
            }
        }

        return $array;
    }
}
