<?php

namespace App\Http\Controllers;

use App\Models\Boleto;
use App\Models\Evento;
use App\Models\Ingresso;
use App\Models\Pedido;
use App\Models\PedidosCancelados;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Str;
use Mail;

class FinanceiroController extends Controller
{

    public function pagamentos()
    {
        return view('admin.financeiro.pagamentos');
    }

    public function FiltrarPagamentos(Request $request)
    {
        $boletos = Boleto::where('payment_id', $request->s)->orwhere('id', $request->s)->get();
        if ($boletos->isNotEmpty()) {
            return view('admin.financeiro.ajax.result-boletos', compact('boletos'));
        }

        // dd($request->all(), $boletos);

        $users = User::whereRaw("CONCAT(name, ' ', sobrenome) LIKE ?", ["%{$request->s}%"])
            ->orWhere('id', 'like', "%{$request->s}%")
            ->orWhere('cpf', 'like', "%{$request->s}%")
            ->orWhere('email', 'like', "%{$request->s}%")
            ->get();

        if ($users->isNotEmpty()) {
            $boletos = Boleto::whereIn('user_id', $users->pluck('id'))->get();
            return view('admin.financeiro.ajax.result-boletos', compact('boletos'));
        }


        dd($boletos, $users);
    }

    public function index(Evento $Evento)
    {

        $Pedidos = Pedido::where('evento_id', $Evento->id)
            ->where('pdv', 'site')
            ->get();

        // Agrupar por sub_total
        $resultados = $Pedidos->groupBy('sub_total')->map(function ($grupo) {
            return [
                'valor' => $grupo->first()->sub_total,
                'quantidade' => $grupo->count(),
                'soma' => $grupo->sum('sub_total'),
            ];
        })->values();

        // dd($resultados);

        return view('admin.evento.financeiro', ['Evento' => $Evento]);
    }

    public function historico(Evento $Evento, Request $request)
    {
        $pedidos = Pedido::where('evento_id', $Evento->id)
            ->when($request->filtro, function ($query, $filtro) {
                if (in_array($filtro, ['Aprovado', 'Pendente', 'Cancelados', 'Manual', 'Site'])) {
                    if ($filtro === 'Cancelados') {
                        $query->where('status', 'Cancelado'); // Ajuste se o nome no banco for diferente
                    } elseif (in_array($filtro, ['Manual', 'Site'])) {
                        $query->where('pdv', $filtro);
                    } else {
                        $query->where('status', $filtro);
                    }
                }
            })
            ->paginate(100);

        if ($request->ajax()) {
            return view('admin.evento.ajax.pedidos', compact('pedidos'))->render();
        }

        return view('admin.evento.historico-transacoes', compact('pedidos'), ['Evento' => $Evento]);
    }


    public function pedido(Pedido $Pedido)
    {
        $Evento = Evento::find($Pedido->evento->id);
        return view('admin.evento.pedido', ['Pedido' => $Pedido, 'Evento' => $Evento]);
    }

    /**
     * Display the specified resource.
     */
    public function CancelamentoPedidoStore(Request $request, $id)
    {
        $Pedido     = Pedido::find($id);
        $Evento     = Evento::find($Pedido->evento_id);
        $Boleto     = Boleto::where('pedido_id', $id)->first();
        $Ingressos  = Ingresso::where('pedido_id', $id)->get();

        $dados = [
            'pedido_id' => $id,
            'motivo'    => $request->motivo,
        ];

        if ($request->hasFile('comprovante_pagamento')) {
            $nameFile = Str::of('comprovante_pagamento')->slug('-') . rand() . '.' . $request->comprovante_pagamento->getClientOriginalExtension();
            $path = $request->comprovante_pagamento->storeAs('cancelamentos', $nameFile);
            $dados['comprovante_pagamento'] = $path;
        }

        if ($request->hasFile('comprovante_estorno')) {
            $nameFile = Str::of('comprovante_estorno')->slug('-') . rand() . '.' . $request->comprovante_estorno->getClientOriginalExtension();
            $path = $request->comprovante_estorno->storeAs('cancelamentos', $nameFile);
            $dados['comprovante_estorno'] = $path;
        }

        PedidosCancelados::create($dados);

        $Pedido->update(['status' => 'Cancelado']);
        $Boleto->update(['status' => '2']);
        foreach ($Ingressos as $ingresso) {
            $ingresso->update(['status' => '2']);
        }

        $user = User::find($Pedido->user_id);
        Mail::send('emails.cancelamento-de-compra', [
            'name'      => $user->name,
            'email'     => $user->email,
            'evento'    => $Evento->titulo,
            'banner'    => url("storage/{$Evento->banner}"),
            'link'      => route('site.evento', [$Evento->url, $Evento->id])
        ], function ($mail) use ($user) {
            $mail->from(env('MAIL_FROM_ADDRESS'), env('MAIL_FROM_NAME')); // E-mail do sistema como remetente
            $mail->to($user->email)->subject('Cancelamento de Ingresso ' . env('APP_NAME')); // O usuário é o destinatário
        });

        return redirect()->back()->with('success', 'Pedido cancelado com sucesso');
    }


    /**
     * Show the form for editing the specified resource.
     */
    public function AprovarPedido(Request $request)
    {
        $Pedido     = Pedido::find($request->id);
        $Boleto     = Boleto::where('pedido_id', $request->id)->first();
        $Ingressos  = Ingresso::where('pedido_id', $request->id)->get();

        $Pedido->update([
            'status' => 'Aprovado',
            'forma_pagamento' => $request->forma_pagamento,
        ]);
        $Boleto->update(['status' => '1']);
        foreach ($Ingressos as $ingresso) {
            $ingresso->update(['status' => '1']);
        }
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
