<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Etiqueta;
use App\Models\Ingresso;
use App\Models\PrintEtiqueta;

class EtiquetaController extends Controller
{

    public function print()
    {
        return view('print.etiqueta');
    }


    public function printID($id)
    {
        $ingresso = Ingresso::findOrFail($id);

        $campos = json_decode($ingresso->campos_personalizados, true) ?? [];

        $dados = [
            'id'      => $ingresso->id,
            'nome'    => $ingresso->nome_completo,
            'cargo'   => $campos['cargo_funcao'] ?? $campos['cargo'] ?? '',
            'empresa' => $campos['instituicao_trabalho'] ?? $campos['empresa'] ?? $campos['recibo'] ?? '',
            'link'    => $campos['qr'] ?? $campos['link'] ?? 'https://linktr.ee/fenasdetran',
        ];


        return view('print.etiqueta-manual', compact('dados'));
    }


    public function pendentes(Request $request)
    {
        $item = PrintEtiqueta::where('status', 'pendente')->first();
        if (!$item) {
            return response()->noContent(); // 204
        }

        $ingresso = Ingresso::find($item->ingresso_id);
        if (!$ingresso) {
            // evita loop infinito caso haja registro órfão
            $item->update(['status' => 'erro']);
            return response()->noContent();
        }

        $dados = [
            'id'     => $ingresso->id,
            'nome'   => $ingresso->nome_completo,
            'campos' => $ingresso->campos_personalizados,
        ];

        $item->update(['status' => 'impresso']);
        return response()->json($dados);
    }
}
