<?php

namespace App\Http\Controllers;

use App\Models\Ingresso;
use Illuminate\Http\Request;
use setasign\Fpdi\Fpdi;
use setasign\Fpdi\PdfReader;

class CertificadoController extends Controller
{
    public function certificado(Request $request)
    {
        $cpf = tiraMoeda($request->cpf);
        $ingresso = Ingresso::where('cpf', $cpf)->first();
        $ingresso->update(['certificado' => $ingresso->certificado + 1]);

        if (!$ingresso) {
            return back()->with('error', 'CPF não encontrado.');
        }

        $modelo = storage_path('app/public/certificados/certificado-congresso.pdf');

        if (!file_exists($modelo)) {
            return back()->with('error', 'Modelo de certificado não encontrado.');
        }

        // Cria o PDF e usa o modelo de fundo
        $pdf = new Fpdi();
        $pdf->setSourceFile($modelo);
        $templateId = $pdf->importPage(1);
        $pdf->AddPage('L'); // modo paisagem
        $pdf->useTemplate($templateId, 0, 0, 297);

        // Configura a fonte e posiciona o nome dentro do texto
        $pdf->SetFont('Arial', 'B', 20);
        $pdf->SetTextColor(0, 0, 128); // azul escuro
        $pdf->SetXY(0, 95); // 👈 suba o nome (antes estava 125)
        $pdf->Cell(0, 10, utf8_decode(strtoupper($ingresso->nome_completo)), 0, 0, 'C');

        // Nome do arquivo final
        $filename = 'Certificado - ' . str_replace(' ', '_', $ingresso->nome_completo) . '.pdf';

        // Retorna o PDF inline no navegador
        return response($pdf->Output('S', $filename))
            ->header('Content-Type', 'application/pdf')
            ->header('Content-Disposition', 'inline; filename="' . $filename . '"');
    }
}
