<?php

namespace App\Http\Controllers;

use App\Models\Analytics;
use App\Models\Evento;
use App\Models\User;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class AnalyticsController extends Controller
{

    protected function sendPushNotification($expoPushToken, $title, $body, $data = [])
    {
        $pushController = app(PushController::class);
        $request = new Request([
            'expoPushToken' => $expoPushToken,
            'title' => $title,
            'body' => $body,
            'data' => $data,
        ]);

        $pushController->sendNotification($request);
    }


    public function pageView(Request $request)
    {
        $array = ['error' => ''];
        $evento = Evento::find($request->event_id);
        $evento->update(['views' => $evento->views + 1]);
        return $array;
    }

    public function DownloadApp(Request $request)
    {
        try {
            $sessionId = $request->session()->getId();
            $userId =   Auth::check() ? Auth::user()->id : null;
            $userName = Auth::check() ? Auth::user()->name : 'Visitante';
            $url = $request->fullUrl();
            $hoje = Carbon::today();

            $acesso = Analytics::where('url', $url)
                ->whereDate('created_at', $hoje)
                ->where(function ($query) use ($sessionId, $userId) {
                    if ($userId) {
                        $query->where('user_id', $userId);
                    } else {
                        $query->where('session_id', $sessionId);
                    }
                })
                ->first();

            if ($acesso) {
                $acesso->increment('views');
            } else {
                Analytics::create([
                    'session_id' => $sessionId,
                    'user_id'    => $userId,
                    'url'        => $url,
                    'ip_address' => $request->ip(),
                    'user_agent' => $request->userAgent(),
                    'referer'    => $request->headers->get('referer'),
                    'views'      => 1,
                ]);
            }
        } catch (\Throwable $e) {
            return redirect()->route('site.home');
        }

        // $user = User::find(5);
        // foreach ($user->pushToken as $push) {
        //     if ($push->token) {
        //         $this->sendPushNotification(
        //             $push->token,
        //             'Nova Visita Download App Apple',
        //             '('.$userId.') '.$userName.' clicou no banner para baixar o APP',
        //             [
        //                 'evento_id'  => 1,
        //             ]
        //         );
        //     }
        // }


        return redirect('https://apps.apple.com/us/app/musa-ticket/id6746232077');
    }
}
