<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;

class UserController extends Controller
{

    public function index()
    {
        $usuarios = User::orderby('nome','ASC')->get();
        return view('admin.usuarios.index',compact('usuarios'));
    }

    public function create()
    {
        return view('app.users.create');
    }

    public function store(Request $request)
    {
        $dados = $request->all();
        $dds = User::where('email',$request->email)->first();
        if($dds){
            return redirect()->back()->with('error','Usuário já esta cadastrado')->withInput();
        }
        $nivel = [
            "Administrador"         => '1',
            "Gerente"               => '2',
            "Fiscal"                => '3',
            "Marinheiro"            => '4',
            "Operador Máquina"      => '4',
            "Convés"      => '4',
        ];

        $dados['nivel']     = $nivel[$request->funcao];
        $dados['password']  = bcrypt($request->password);
        User::create($dados);
        return redirect()->back()->with('success','Usuário cadastrado com sucesso');
    }

    public function show($id)
    {
        $user = User::find($id);
        return view('app.users.show',['user'=>$user]);
    }

    public function update(Request $request, $id)
    {
        // dd($request->all());
        $user = User::find($id);
        $dados = $request->all();
        $dds = User::where('email',$request->email)->where('id','!=',$id)->first();
        // dd($request->all(),$dds);

        if(!empty($dds->email)){
            if($dds->email == $request->email){
                return redirect()->back()->with('error','Usuário já esta cadastrado')->withInput();
            }
        }

        $nivel = [
            "Administrador"         => '1',
            "Gerente"               => '2',
            "Fiscal"                => '3',
            "Marinheiro"            => '4',
            "Operador Máquina"      => '4',
            "Convés"      => '4',
        ];


        $dados['nivel']     = $nivel[$request->funcao];
        if(!empty($request->password)){
            $dados['password']  = bcrypt($request->password);
        }
        $user->update($dados);
        return redirect()->back()->with('success','Usuário atualizado com sucesso');
    }

    public function UpdatePerfilMotoboy(Request $request, $id)
    {

        if ($request->senha != $request->senha2 && $request->senha2 != null) {
            return redirect()->back()->with('error', 'As senhas devem ser iguais');
        } else {

            $user                   = User::find($id);
            $dados['nome']          = $request->nome;
            $dados['doc']           = $request->doc;
            $dados['email']         = $request->email;
            $dados['celular']       = $request->celular;
            $dados['cep']           = $request->cep;
            $dados['endereco']      = $request->endereco;
            $dados['numero']        = $request->numero;
            $dados['complemento']   = $request->complemento;
            $dados['bairro']        = $request->bairro;
            $dados['cidade']        = $request->cidade;
            $dados['estado']        = $request->estado;

            $nome                   = $request->nome;
            if ($request->arq) {
                $nameFile               = Str::of($nome)->slug('-') . rand() . '.' . $request->arq->getClientOriginalExtension();
                $dados['foto']          = $request->arq->storeAs('fotos', $nameFile);
            }
            if ($request->arq) {
                $dados['password']          = $request->senha;
            }
            $user->update($dados);
            return redirect()->back()->with('success', 'Dados atualizado com sucesso');
        }
    }

    public function UpdateFoto(Request $request)
    {
        $user = User::find(Auth::user()->id);
        $nameFile       = Str::of(Auth::user()->name)->slug('-') . rand() . '.' . $request->foto->getClientOriginalExtension();
        $dados['foto']  = $request->foto->storeAs('self', $nameFile);

        $user->update($dados);
        return redirect()->back()->with('success', 'Dados atualizado com sucesso');
    }

    public function privacidade(Request $request)
    {
        $user = User::find(Auth::user()->id);
        $dados['privacidade'] = $user->privacidade == '0' ? '1' : '0';
        $user->update($dados);

        return response()->json([
            'ico'       => $user->privacidade == '0' ? '<ion-icon name="eye-outline"></ion-icon>' : '<ion-icon name="eye-off-outline"></ion-icon>',
            'carteira'  => $user->privacidade == '0' ? 'R$ '.moeda($request->total) : 'R$ ••••••',
        ]);

    }

    public function logar($id){
        $user = User::find($id);
        Auth::login($user);
        return redirect()->route('painel');
    }
}
